#ifndef ZMODELER_STRUCT_MATH_H_INCLUDED
#define ZMODELER_STRUCT_MATH_H_INCLUDED
#include "ZMMatrix.h"
//-----------------------------------------
//    Custom ZModeler Math functions.
//-----------------------------------------

// converts supplied numeral to CString.
DllExport CString Int2String(long val);

// converts supplied CString to numeral.
DllExport long String2Int(CString s);

DllExport CString GetValidName(CString str);  //extracts menu-style name (with '&')
DllExport CString GetNameString(CString str); //same as GetValidName, but removes '&' too.
DllExport CString GetValidProcName(CString str);//full name-to-procname conversion.
DllExport CString  GetValidFolderName(CString folder);
          
// float square root
DllExport float sqr(float x);

// numeral square root
DllExport int sqr(int x);
DllExport float sgn(float val);

// float result of division
#define fdivide(a,b) ((float)(a)/(float)(b))

// float minimum of two arguments
#define minimum(a, b) ((a) < (b) ? (a) : (b))
#define maximum(a, b) ((a) > (b) ? (a) : (b))

// float length of supllied vector
DllExport float VectLen(float x, float y, float z);
// float distance between two numeral (screen) points
DllExport float ScreenDist(int startx, int starty, int endx, int endy);
// float distance between two float (planar) points
DllExport float Dist2D(float startx, float starty, float endx, float endy);
// float distance between two points in 3D space.
DllExport float Dist3D(float startx, float starty, float startz, float endx, float endy, float endz);
// converts 3D point to planar point (in suppllied view)
DllExport tPOINT2D Make2D(tPOINT p, z3dViewDescriptor* pView);
// converts 3D point to planar point (in suppllied view)
DllExport tPOINT2D Make2D(float x,float y,float z, z3dViewDescriptor* pView);
// converts planar point to 3D point (in suppllied view), using tPOINT Axis
DllExport tPOINT Make3D(tPOINT2D p, z3dViewDescriptor* pView);
// converts planar point to 3D point (in suppllied view), using tPOINT Axis
DllExport tPOINT Make3D(float x, float y, z3dViewDescriptor* pView);

// valid convertion of float to screen numeral (avoids overflow)
DllExport int ValidateInt(float f);

// converts point in 3DSpace to 3DView's or UserView's screen coordinates (z is ignored)
DllExport tPOINT De3DPoint(float x, float y, float z, z3dViewDescriptor* pView);
DllExport tPOINT QuickDe3DPoint(float x, float y, float z, tMATRIX& view,  tMATRIX& proj);
// returns an angle (in radians) between two vectors:
// planar, in supplied view
DllExport float Angle(tPOINT np1,tPOINT np2,tPOINT np3, z3dViewDescriptor* pView);
// returns an angle (in radians) between two vectors
DllExport float Angle(float x1,float y1,float z1,
      float x2,float y2,float z2,
      float x3,float y3,float z3,
      z3dViewDescriptor* pView);

DllExport void RotateAround(tPOINT* v, tPOINT* axis, float angle, tPOINT* base = NULL);

//  returns TRUE if projections of two lines in supplied view are crossed
DllExport BOOL IsCrossed(tPOINT sp1,tPOINT ep1,tPOINT sp2, tPOINT ep2, z3dViewDescriptor* pView);
// calculates normal to supplied (by three points) 3D plane
DllExport tPOINT GetNormal(float x1,float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3);

// calculates Sin of an angle between two vectors: (0,p1)x(0,p2)
DllExport float GetSinAB(float x1,float y1, float z1, float x2, float y2, float z2);
// calculates Cos of an angle between two vectors: (0,p1)x(0,p2)
DllExport float GetCosAB(float x1,float y1, float z1, float x2, float y2, float z2);

// converts 3D point to screen coordinates of supplied view
DllExport POINT ConvertToScreen(
            float _X,
            float _Y,
            float _Z,
            z3dViewDescriptor* pView);
// converts screen coordinates of supplied view to 3D point.
DllExport tPOINT ConvertFromScreen(  int ScreenX,
              int ScreenY,
              z3dViewDescriptor* pView);
// converts point to userview-screen point. Requires applying PrepareUserViewConvertions
// function.
DllExport POINT UserToScreen(
            float _X,
            float _Y,
            float _Z,
            z3dViewDescriptor* pView,
            tMATRIX& view,
            tMATRIX& proj);
DllExport void PrepareUserViewConvertions(
            z3dViewDescriptor* pView,
            tMATRIX& view, //out
            tMATRIX& proj);//out

// tries to project (returns TRUE on success) a point to supplied edge.
// the point of projection is returned in supplied pointer. Returns TRUE
// is this point is inside of the edge
DllExport BOOL ProjectPointToEdge(  float edgex1, float edgey1, float edgez1,
                  float edgex2, float edgey2, float edgez2,
                  float x, float y, float z,
                  z3dViewDescriptor* pView,
                  tPOINT*  pResult);//returns TRUE if passed.
// tries to project (returns TRUE on success) a line onto triangle (in 3D).
// The point of projection is returned in supplied pointer. Returns TRUE
// if this point is inside of triangle.
DllExport BOOL ProjectLineToPlane(  float facex1, float facey1, float facez1,
                  float facex2, float facey2, float facez2,
                  float facex3, float facey3, float facez3,
                  float x1, float y1, float z1,
                  float x2, float y2, float z2,
                  tPOINT*  pResult);//returns TRUE if non-parallel.
// Projects point to triangle and returns "WeightCoefficients" of the vertices
// of this triangle, that describes where the point is. For example, weights
// 0.1, 0,7, and 0.4 are stands for:
// tPOINT(cross) = 0.1*tPOINT(1st vert) + 0.7*tPOINT(2nd) + 0.4*tPOINT(3rd).
DllExport BOOL GetWeightCoefficients(float facex1, float facey1, float facez1,
                  float facex2, float facey2, float facez2,
                  float facex3, float facey3, float facez3,
                  float innerx, float innery, float innerz,
                  float *p1, float *p2, float *p3);//returns TRUE if passed
// Returns TRUE if supplied point is inside of supplied face. This point is supposed
// to lie on face's plane or be very close to it.
DllExport BOOL IsPointInFace(    float facex1, float facey1, float facez1,
                  float facex2, float facey2, float facez2,
                  float facex3, float facey3, float facez3,
                  float pointx, float pointy, float pointz);
// Returns TRUE if supplied screen point is in supplied screen triangle
DllExport BOOL IsPointInFace(POINT p1,POINT p2,POINT p3,POINT p, BOOL SeeTroughMode);
// Tires (returns TRUE on success) to get the distance from point to edge in supplied view.
DllExport BOOL DistFromPointToEdge(  float edgex1, float edgey1, float edgez1,
                  float edgex2, float edgey2, float edgez2,
                  float x, float y, float z,
                  z3dViewDescriptor* pView,
                  float*  pDist);
// Returns TRUE if supplied screen points makes CCW triangle
DllExport BOOL IsFaceVisible(POINT p1, POINT p2, POINT p3);

// Returns TRUE if supplied view is any of side (left/right)views
DllExport BOOL IsSide(ViewMode View);
// Returns TRUE if supplied view is any of vertical (top/bottom) views
DllExport BOOL IsTop(ViewMode View);
// Returns TRUE if supplied view is any of frontal (front/rear) views
DllExport BOOL IsFrontal(ViewMode View);

DllExport long  DistToScreen(float dist, z3dViewDescriptor* pView);
DllExport float ScreenToDist(long screen, z3dViewDescriptor* pView);


#endif //ZMODELER_STRUCT_LIST_H_INCLUDED
